#pragma warning (disable : 4786)
#pragma warning (disable : 4018)
#pragma warning (disable : 4244)
#pragma warning (disable : 4800)

#include <string>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <shlwapi.h>

#include "objects.h"
#include "resource.h"
#include "adv_assert.h"

extern HINSTANCE ghInstance;

std::string GetWorkDir ()  
{  
     std::string sModulePath;  
     char pModuleBuffer [ _MAX_PATH +  1 ];  
      
     GetModuleFileName ( NULL, pModuleBuffer, MAX_PATH ) ;  
  
     PathRemoveFileSpec ( pModuleBuffer ) ;  
     PathAddBackslash ( pModuleBuffer ) ;  
     sModulePath = pModuleBuffer;  
  
    return sModulePath ;  
}  

std::string GetSaveFile ()
{
	return GetWorkDir() + "lastgame.txt";
}

/****************************************************************/
/* CGameCard                                                    */
/****************************************************************/

CGameCard::CGameCard(int x0, int y0, int xl, int yl, int v, Suits s, int ID)
{
	Assert(((v >= 1) && (v <= NUMBER_OF_CARDS_IN_SUIT)), "CGameCard: Wrong value");
	Assert(((s >= 0) && (s < NUMBER_OF_SUITS)), "CGameCard: Wrong suit");
	Assert(((ID >= 0) && (ID < NUMBER_OF_CARDS_IN_DECK)), "CGameCard: ID error");
	this -> x0 = x0;
	this -> y0 = y0;
	this -> xl = xl;
	this -> yl = yl;
	this -> Value = v;
	this -> Suit = s;
	this -> ID = ID;

	IsFaceUp = false;
	int FileNum = ((int) Suit) * NUMBER_OF_CARDS_IN_SUIT + Value;
	sprintf ( PictName, "IDB_CARD%d", FileNum );
}


// Used only for debug purpose
CGameCard::CGameCard()
{
	this->x0 = 350;
	this->y0 = 360;
	this->xl = 70;
	this->yl = 80;
	this->Value = 5;
	this->Suit = Club;
	this -> ID = 0;

	IsFaceUp = true;
	int FileNum = ((int) Suit) * NUMBER_OF_CARDS_IN_SUIT + Value;
	sprintf ( PictName, "IDB_CARD%d", 5 );
}

void CGameCard::Draw(HDC h)
{
	Assert((int)h, "HDC is not set");

	HDC hMemDC;

	HBITMAP hCardBitmap;

	if(IsFaceUp) 
		hCardBitmap = LoadBitmap(ghInstance, PictName);
	else
		hCardBitmap = LoadBitmap(ghInstance, "IDB_DECK");


	hMemDC= CreateCompatibleDC (h);
	SelectObject (hMemDC, hCardBitmap);
	BitBlt (h, x0, y0, xl, yl, hMemDC, 0, 0, SRCCOPY);
	DeleteDC (hMemDC);
	DeleteObject (hCardBitmap);
}

bool CGameCard::IsInside(int x, int y)
{
	if ((x >= x0) && (x <= x0 + xl) && (y >= y0) && (y <= y0 + yl))
		return true;
	return false;
}

bool CGameCard::Side()
{
	return IsFaceUp;
}

void CGameCard::SetSide(bool s)
{
	IsFaceUp=s;
}

void CGameCard::ReverseSide()
{
	IsFaceUp = !IsFaceUp;
}

void CGameCard::ChangeCoordsBy(int dx, int dy)
{
	x0+=dx;
	y0+=dy;
}

RECT CGameCard::GetCardCoords()
{
	RECT R;
	R.left = x0;
	R.right = x0 + xl;
	R.top = y0;
	R.bottom = y0 + yl;
	return R;
}

void CGameCard::GetCardCoords(int &x, int &y)
{
	x = x0;
	y = y0;
}

void CGameCard::SetCardCoords(int NewX, int NewY)
{
	x0 = NewX;
	y0 = NewY;
}

int CGameCard::GetCardValue()
{
	return Value;
}

Suits CGameCard::GetCardSuit()
{
	return Suit;
}

SuitColors CGameCard::GetCardColor()
{
	if ((Suit == Diamond) || (Suit == Heart))
		return Red;
	return Black;
}

SuitColors GetColor (Suits s)
{
	if ((s == Diamond) || (s == Heart))
		return Red;
	return Black;
}

int CGameCard::GetCardID()
{
	return ID;
}

bool GetCardValueAndSuitByID(int id, int &v, Suits &s)
{
	if((id < 0) || (id >= NUMBER_OF_CARDS_IN_DECK)) return false;
	id /= 2;
	v = (id % NUMBER_OF_CARDS_IN_SUIT) + 1;
	s = (Suits) (id / NUMBER_OF_CARDS_IN_SUIT);
	return true;
}

void CGameCard::CardReset()
{
	x0 = -200;	
	y0 = -200;
	IsFaceUp = false;
}


/****************************************************************/
/* CCardAddress                                                 */
/****************************************************************/

CCardAddress::CCardAddress(int  CardID, CGameCard* Addr)
{
	this -> CardID = CardID;
	this -> Addr = Addr;
	this -> Used = false;
}

int CCardAddress::GetID()
{
	return CardID;
}
CGameCard* CCardAddress::GetAddress()
{ 
	return Addr;
}
CCardAddress::~CCardAddress()
{
	Addr = NULL;
}
/****************************************************************/
/* CColumnAddress                                               */
/****************************************************************/

CColumnAddress::CColumnAddress(int  ColumnID, CColumn* Addr)
{
	this -> ColumnID = ColumnID;
	this -> Addr = Addr;
}

int CColumnAddress::GetID()
{
	return ColumnID;
}
CColumn* CColumnAddress::GetAddress()
{ 
	return Addr;
}

/****************************************************************/
/* CAllCards                                                    */
/****************************************************************/

void CAllCards::Init()
{
	int id = 0;
	for(int s = 0; s < NUMBER_OF_SUITS; s++)
		for(int v = 1; v <= NUMBER_OF_CARDS_IN_SUIT; v++)
		{
			for(int i = 0; i < NUMBER_OF_COPIES; i++)
			{
				AllCards[id] = new CGameCard(-200,
				-200, CARDWIDTH, CARDHEIGHT, v, (Suits)s, id);
				id++;
			}
		}
	Used = 0; 
}

void CAllCards::CardsToColumn(int NumberOfCards, std::list <CGameCard*> &ToColumn)
{	
	int i=0;
	while((i < NumberOfCards)&&(Used < NUMBER_OF_CARDS_IN_DECK))
	{
		ToColumn.push_front(AllCards[Used]);
		Used++;
		i++;
	}
}

void CAllCards::NewSort()
{
	int j;
	CGameCard* Karta;
	srand((unsigned)time( NULL ));
	for(int i = 0; i < NUMBER_OF_CARDS_IN_DECK; i++)
	{
		Karta = AllCards[i];
		j = (int) (rand() * NUMBER_OF_CARDS_IN_DECK / RAND_MAX);
		if(j == NUMBER_OF_CARDS_IN_DECK) j--;   
		AllCards[i] = AllCards[j];
		AllCards[j] = Karta;
	}
	Used = 0;
}

bool SaveInt(int i, FILE* out)
{
	int res = fwrite (&i, sizeof (int), 1, out);
	return (res > 0);
}

bool SaveChar(int c, FILE* out)
{
	int res = fwrite (&c, sizeof (char), 1, out);
	return (res > 0);
}

bool ReadInt(int &i, FILE* in)
{
	if (feof(in)) return false;
	int res = fread (&i, sizeof (int), 1, in);
	if (ferror(in)) return false;
	return (res > 0);
}

bool ReadChar(int &c, FILE* in)
{
	if (feof(in)) return false;
	int res = fread (&c, sizeof (char), 1, in);
	if (ferror(in)) return false;
	return (res > 0);
}

void CAllCards::Restart()
{
	Used = 0;
}

CAllCards::~CAllCards ()
{
	using namespace std;
	for(int i = 0; i < NUMBER_OF_CARDS_IN_DECK; i++)
	  delete (AllCards[i]);
}

bool CAllCards::Save(FILE* stream)
{
	int i, j, k;
	int NUMBER_OF_DEST_COLUMNS = NUMBER_OF_SUITS * NUMBER_OF_COPIES;
	int CardID;

	k = 0;
	for(i = 0; i < NUMBER_OF_DEST_COLUMNS; i++)
	{
		for (j = 0; j < NUMBER_OF_CARDS_IN_SUIT; j++)
		{
			CardID = AllCards[k] -> GetCardID();
			k++;
			if(!SaveInt(CardID, stream)) return false;
		}
	}
	Used = 0;
	return true;
}

bool TestIDList(std::list <CCardAddress*> IDList, FILE* stream)
{
	using namespace std;
	list <CCardAddress*>::iterator C_Iter;
	CCardAddress* CurrentAddress;
	int CurrentID, i = 0;

	for(C_Iter = IDList.begin(); C_Iter != IDList.end(); C_Iter++)	
	{
		CurrentAddress = (CCardAddress*) *C_Iter;
		CurrentID = CurrentAddress -> GetID();
		if(stream != NULL) fprintf(stream, "%d:%d,  ", i, CurrentID);
		i++;
	}
	return true;
}
bool FindIDInList(std::list <CCardAddress*> &IDList, int id, CGameCard* Address)
{
	using namespace std;
	list <CCardAddress*>::iterator C_Iter;
	int CurrentID;
	CCardAddress* CurrentAddress;
	CCardAddress* NewAddress = NULL;
	bool res = false;
	for(C_Iter = IDList.begin(); C_Iter != IDList.end(); C_Iter++)	
	{
		CurrentAddress = (CCardAddress*) *C_Iter;
		CurrentID = CurrentAddress -> GetID();
		if(id == CurrentID) 
		{
			res = true;
			break;
		}
		if(id < CurrentID)
		{
			NewAddress = new CCardAddress(id, Address);
			break;
		}
	}
	if(!res)
	{
		NewAddress = new CCardAddress(id, Address);
		if(NewAddress != NULL)
			IDList.insert(C_Iter, NewAddress);
	}
	return res;
}

bool CAllCards::Load(FILE* stream, std::list <CCardAddress*> &UsedIDs)
{
	using namespace std;
	list <CCardAddress*>::iterator C_Iter;
	int i;
	bool res = false;
	int NUMBER_OF_DEST_COLUMNS = NUMBER_OF_SUITS * NUMBER_OF_COPIES;
	int CardID;
	int CardValue;
	Suits CardSuit;
	UsedIDs.clear(); 
	for( i = 0; i < NUMBER_OF_CARDS_IN_DECK; i++)
	{
		res = ReadInt(CardID, stream);
		if(res)
		{
			GetCardValueAndSuitByID(CardID, CardValue, CardSuit);
			AllCards[i] = new CGameCard(-200, -200, CARDWIDTH,
				CARDHEIGHT,	CardValue, CardSuit, CardID);
		}
		if ((!res) || FindIDInList(UsedIDs, CardID, AllCards[i]))
		{
			for(C_Iter = UsedIDs.begin(); C_Iter != UsedIDs.end(); C_Iter++)
				delete (*C_Iter); 
			UsedIDs.clear();
			for(int j = i; j >= 0; j--)
			delete (AllCards[j]);
			Init();
			res = false;
			break;
		}
	}
	return res;	
}
/****************************************************************/
/* CColumn                                                      */
/****************************************************************/

CColumn::CColumn(int x0, int dx_pict, int dx_deck, int dx_max, 
		int y0, int dy_pict, int dy_deck, int dy_max, int column_ID)
{
	this->x0 = x0;
	this->dx_pict = dx_pict;
	this->dx_deck = dx_deck;
	this->dx_max  = dx_max;
	this->y0 = y0;
	this->dy_pict = dy_pict;
	this->dy_deck = dy_deck;
	this->dy_max  = dy_max;
	this ->Type = "Column";
	this->column_ID = column_ID;
}

CColumn::CColumn()
{
	this->x0 = 30;
	this->dx_pict = 15;
	this->dx_deck = 1;
	this->dx_max  = 10000;
	this->y0 = 10;
	this->dy_pict = 0;
	this->dy_deck = 0;
	this->dy_max  = 10000;
	this ->Type = "Column";
	this->column_ID = 0;
}

void CColumn::Draw (HDC h)
{
	using namespace std;	
	if(Cards.empty())
	{
		HBRUSH NewBrush = CreateSolidBrush(RGB(100, 100, 250));
		HBRUSH hbrSave = (HBRUSH)SelectObject(h, NewBrush);
		RoundRect(h, x0, y0, x0+CARDWIDTH, y0+CARDHEIGHT, 
			20 , 20);
		SelectObject(h, hbrSave);
		DeleteObject(NewBrush);
	}
	else
	{
		list <CGameCard*>::iterator C_Iter;
		for(C_Iter=Cards.begin (); C_Iter!=Cards.end (); C_Iter++)
			(*C_Iter)->Draw(h);  
	}
}

CGameCard* CColumn::GetCardToMove(int MouseX, int MouseY)
{
	using namespace std;
	list <CGameCard*>::reverse_iterator C_Iter;
	for(C_Iter=Cards.rbegin (); C_Iter!=Cards.rend (); C_Iter++)
	{
		CGameCard* Karta;
		Karta = (CGameCard*) *C_Iter;

		if(Karta->IsInside(MouseX, MouseY)) return Karta;	
    }
	return NULL;
}

void CColumn::GetSubColumnList(int NumOfCards, std::list <CGameCard*> &NewCards)
{
	using namespace std;
	list <CGameCard*>::reverse_iterator C_Iter;
	CGameCard* Karta;
	NewCards.clear();
	if(NumOfCards > Cards.size()) NumOfCards = Cards.size();
	C_Iter = Cards.rbegin ();
	for(int i = 0; i < NumOfCards; i++)
	{
		Karta = (CGameCard*) *C_Iter;
		NewCards.push_back (Karta);
		C_Iter++;
	}
}

void CColumn::GetSubColumnToMove(std::list <CGameCard*> &NewCards, int &x, 
								int &x_pict, int &y, int &y_pict, std::string &pType, 
								int NumOfCardsToMove)
{
	using namespace std;
	list <CGameCard*>::reverse_iterator C_Iter;
	CGameCard* Karta;

		x_pict = dx_pict;
		y_pict = dy_pict;
		pType = Type;

		NewCards.clear();
		if(NumOfCardsToMove > Cards.size()) NumOfCardsToMove = Cards.size();
		for(int i = 0; i < NumOfCardsToMove; i++)
		{
			C_Iter = Cards.rbegin ();
			Karta = (CGameCard*) *C_Iter;
			NewCards.push_back (Karta);
			Cards.remove(Karta);
		}
		if(NumOfCardsToMove > 0) 
		{
			C_Iter = NewCards.rbegin();
			Karta = (CGameCard*) *C_Iter;
			Karta->GetCardCoords(x, y);
		}	
}

void CColumn::GetNextCardCoords(int &NewX, int &NewY)
{
	using namespace std;
	list <CGameCard*>::reverse_iterator R_Iter;
	CGameCard* Karta;

	if(Cards.empty()) 
	{
		NewX=x0; 
		NewY=y0;
	} 
	else 
	{
		R_Iter = Cards.rbegin ();
		Karta = (CGameCard*) *R_Iter;
		Karta->GetCardCoords(NewX, NewY);
		if(Karta->Side()) {NewX+=dx_pict; NewY+=dy_pict;}
			else {NewX+=dx_deck; NewY+=dy_deck;}
	}
}

void CColumn::AddCard (CGameCard* pObj)
{	
	using namespace std;
	int NewX, NewY;
	bool NextRow = false;

	GetNextCardCoords(NewX, NewY);
	int dest_x, dest_y;
	if (dx_pict > 0) dest_x = 1;
		else if (dx_pict < 0) dest_x = -1;
			else dest_x = 0;

	if (dy_pict > 0) dest_y = 1;
		else if (dy_pict < 0) dest_y = -1;
			else dest_y = 0;

	if((NewX * dest_x) > (dx_max * dest_x))
		{
			NewX = x0;
			NewY += (CARDHEIGHT + 2);
			NextRow = true;
		}

		if(((NewY * dest_y) > (dy_max * dest_y)) && (!NextRow))
		{
			NewY = y0;
			NewX += (CARDWIDTH + 2);
			NextRow = true;
		}
	pObj -> SetCardCoords(NewX, NewY);
	Cards.push_back(pObj);
}

void CColumn::AddSubColumn (std::list <CGameCard*> NewCards)
{
	using namespace std;
	list <CGameCard*>::iterator R_Iter;
	int NewX, NewY;
	bool NextRow = false;
	CGameCard* Karta;
	if(NewCards.empty()) return;
	GetNextCardCoords(NewX, NewY);
	int dest_x, dest_y;
	if (dx_pict > 0) dest_x = 1;
		else if (dx_pict < 0) dest_x = -1;
			else dest_x = 0;

	if (dy_pict > 0) dest_y = 1;
		else if (dy_pict < 0) dest_y = -1;
			else dest_y = 0;

	for(R_Iter=NewCards./*r*/begin (); R_Iter!=NewCards./*r*/end (); R_Iter++)
	{
		if((NewX * dest_x) > (dx_max * dest_x))
		{
			NewX = x0;
			NewY += (CARDHEIGHT + 2);
			NextRow = true;
		}
		if(((NewY * dest_y) > (dy_max * dest_y)) && (!NextRow))
		{
			NewY = y0;
			NewX += (CARDWIDTH + 2);
			NextRow = true;
		}
		Karta = (CGameCard*) *R_Iter; 
		Karta -> SetCardCoords(NewX, NewY);
		if(Karta->Side()) {NewX+=dx_pict; NewY+=dy_pict;}
				else {NewX+=dx_deck; NewY+=dy_deck;}
		Cards.push_back(Karta);
		NextRow = false;
	}
	NewCards.clear();
}

void CColumn::MoveColumnBy(int dx, int dy)
{
	x0 += dx;
	y0 += dy;

	CGameCard* Karta;
	std::list <CGameCard*>::iterator C_Iter;
	for(C_Iter=Cards.begin (); C_Iter!=Cards.end (); C_Iter++)
	{
		Karta = (CGameCard*) *C_Iter;
		Karta -> ChangeCoordsBy(dx, dy);
	}
}

int CColumn::NumOfCardsInColumn()
{
	return Cards.size();
}

void CColumn::OpenLastCards (int NumOfCards)
{
	using namespace std;
	if(NumOfCards > Cards.size()) NumOfCards = Cards.size();
	list <CGameCard*>::reverse_iterator R_Iter;
	CGameCard* Karta;
	R_Iter = Cards.rbegin ();
	bool Side;
	for(int i = 0; i < NumOfCards; i++)
	{
		Karta = (CGameCard*) *R_Iter;
		Side = Karta -> Side();
		Karta -> SetSide(!Side);
		R_Iter++;
	}
}

void OpenLastCards (std::list <CGameCard*> &NewCards, int NumOfCards)
{
	using namespace std;
	bool Side;
	if(NumOfCards > NewCards.size()) NumOfCards = NewCards.size();
	list <CGameCard*>::reverse_iterator R_Iter;
	CGameCard* Karta;
	R_Iter = NewCards.rbegin ();
	for(int i = 0; i < NumOfCards; i++)
	{
		Karta = (CGameCard*) *R_Iter;
		Side = Karta -> Side();
		Karta -> SetSide(!Side);
		R_Iter++;
	}
}

void CColumn::OnlyTest()
{
	using namespace std;
    list <int> c1;
    list <int>::iterator c1_Iter;
   
    c1.push_back( 5 );
    c1.push_back( 100 );
    c1.push_back( 5 );
    c1.push_back( 200 );
    c1.push_back( 5 );
    c1.push_back( 300 );

	char str [100], res[100];
	sprintf ( res, "");

    for(c1_Iter=c1.begin (); c1_Iter!=c1.end (); c1_Iter++)
	{
		(*c1_Iter)++;
		sprintf ( str, "%d ", *c1_Iter );
		strcat (res, str);
	}
	c1.clear();
}

std::string CColumn::GetType()
{
	return Type;
}

void CColumn::ColumnReset()
{
	using namespace std;
	list <CGameCard*>::reverse_iterator R_Iter;
	CGameCard* Karta;
	for(R_Iter = Cards.rbegin (); R_Iter != Cards.rend (); R_Iter++)
	{
		Karta = (CGameCard*) *R_Iter;
		Karta -> CardReset();
	}	
	Cards.clear();
}

bool CColumn::IsEmpty()
{
	using namespace std;
	if(Cards.empty()) return true;
	return false;
}
bool CColumn::GetLastCardValueAndSuit(int &v, Suits &s)
{
	using namespace std;
	if(Cards.empty()) return false;
	list <CGameCard*>::reverse_iterator R_Iter;
	CGameCard* Karta;
	R_Iter = Cards.rbegin ();
	Karta = (CGameCard*) *R_Iter;
	v = Karta -> GetCardValue();
	s = Karta -> GetCardSuit();
	return true;
}

int CColumn::GetColumnID()
{
	return column_ID;
}

bool CColumn::Save(FILE* stream)
{
	using namespace std;	
	list <CGameCard*>::iterator C_Iter;
	CGameCard* Karta;

	if(!SaveInt(Cards.size(), stream)) return false;
	for(C_Iter=Cards.begin (); C_Iter!=Cards.end (); C_Iter++)
	{
		Karta = (CGameCard*) *C_Iter;
		if(!SaveInt(Karta -> GetCardID(), stream)) return false;
	}
	return true;
}
bool FindAddressInList(std::list <CCardAddress*> &IDList, int id, CGameCard* &Address)
{
	using namespace std;
	list <CCardAddress*>::iterator C_Iter;
	int CurrentID;
	CCardAddress* CurrentAddress;

	bool res = false;
	for(C_Iter = IDList.begin(); C_Iter != IDList.end(); C_Iter++)	
	{
		CurrentAddress = (CCardAddress*) *C_Iter;
		CurrentID = CurrentAddress -> GetID();
		if(id == CurrentID) 
		{
			Address = CurrentAddress -> GetAddress();
			res = true;
			IDList.erase(C_Iter);
			delete CurrentAddress;
			break;
		}
		if(id < CurrentID)
		{
			res = false;
			break;
		}
	}
	return res;
}

bool CColumn::Load(FILE* stream, std::list <CCardAddress*> &UsedIDs)
{
	using namespace std;	
	CGameCard* Karta;
	int i;
	int CurrentCardID;
	bool CurrentCardSide;
	int NumOfCardsToLoad;
	if(!ReadInt(NumOfCardsToLoad, stream)) return false;
	if((NumOfCardsToLoad < 0) || (NumOfCardsToLoad > NUMBER_OF_CARDS_IN_DECK))
		return false;
	if((Type == "CSP") || (Type == "RDP")) CurrentCardSide = false;
	else CurrentCardSide = true;
	for(i = 0; i < NumOfCardsToLoad; i++)
	{
		if(!ReadInt(CurrentCardID, stream)) return false;
		if(!FindAddressInList(UsedIDs, CurrentCardID, Karta)) return false;
		if(Karta == NULL) return false;
		Karta -> SetSide(CurrentCardSide);
		AddCard (Karta);
	}
	if(Type == "RDP") OpenLastCards(1);
	return true;
}
CColumn::~CColumn ()
{
	Cards.clear();
}

/****************************************************************/
/* CTemporaryPile                                               */
/****************************************************************/

void DoEvents()
{
  MSG msg;
  while ( PeekMessage(&msg, NULL, NULL, NULL, 1 ))
  {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
}

CTemporaryPile::CTemporaryPile() : CColumn ()
{
	Visible = false;
	this -> Type = "Temp";
	this -> Mode = "Mouse";
}

bool CTemporaryPile::IsVisible()
{
	return Visible;
}

void CTemporaryPile::SetTemporaryPile(CColumn* CardsSrc, int NumOfCards, 
									  std::string Mode)
{	
	std::list <CGameCard*>::iterator C_Iter;
	CGameCard* Karta;
	std::list <CGameCard*> SomeCards;
	CardsSrc -> GetSubColumnToMove(SomeCards, x0, dx_pict, y0, dy_pict, 
									 SrcType, NumOfCards);
	
	if(!SomeCards.empty())	
	{
		C_Iter = SomeCards.begin();
		Karta = (CGameCard*) *C_Iter;
		Karta -> GetCardCoords(StartX, StartY);
		Visible = true; 
		this -> Mode = Mode;
		this -> CardsSrc = CardsSrc; 
	}
	
	for(C_Iter = SomeCards.begin(); C_Iter!=SomeCards.end(); C_Iter++)
	{
		Karta = (CGameCard*) *C_Iter;
		Cards.push_front(Karta);
	}
	SomeCards.clear();
}

void CTemporaryPile::GetFromTemporaryPile(CColumn* &SrcPile, 
						std::list <CGameCard*> &ToColumn, 
						std::string &PileType)
{
	ToColumn.clear();
	std::list <CGameCard*>::iterator C_Iter;
	CGameCard* Karta;
	SrcPile = CardsSrc;
	PileType = SrcType;
	for(C_Iter = Cards.begin (); C_Iter != Cards.end (); C_Iter++)
	{
		Karta = (CGameCard*) *C_Iter;
		ToColumn.push_front(Karta);
	}
}

void CTemporaryPile::ResetTemporaryPile()
{
	Visible = false;
	Cards.clear();
	Mode = "Mouse";
}
void CTemporaryPile::ReturnTemporaryPile(HWND hWnd, bool TurnMoving)
{
	int CurrentX, CurrentY;
	std::list <CGameCard*>::iterator C_Iter;
	CGameCard* Karta;
	if(TurnMoving)
	{
		for(C_Iter = Cards.begin(); C_Iter!=Cards.end (); C_Iter++)
		{
			Karta = (CGameCard*) *C_Iter;
			Karta -> ReverseSide();
		}
	}
	C_Iter = Cards.begin();
	Karta = (CGameCard*) *C_Iter;
	Karta->GetCardCoords(CurrentX, CurrentY);
	int LengthX = StartX - CurrentX ;
	int LengthY = StartY - CurrentY;
	int XPassed, YPassed;
	if((CurrentX == StartX) && (CurrentY == StartY)) 
	{
		CardsSrc ->AddSubColumn(Cards);
		ResetTemporaryPile();
		return;
	}
	clock_t start = clock ();
	double dSecs; 
	while (true)
	{
		DoEvents();
		clock_t end = clock ();
		dSecs = ( (double) ( end - start ) ) / CLK_TCK;
		if (dSecs > DMAXPASSED) 
		{
			CardsSrc ->AddSubColumn(Cards);
			ResetTemporaryPile();
			return;
		}
	
		int CardsCounter = 0;
		for(C_Iter = Cards.begin(); C_Iter!=Cards.end (); C_Iter++)
		{
			Karta = (CGameCard*) *C_Iter;
			XPassed = CurrentX + CardsCounter * dx_pict + 
						LengthX * dSecs/DMAXPASSED;
			YPassed = CurrentY + CardsCounter * dy_pict + 
						LengthY * dSecs/DMAXPASSED;
			Karta->SetCardCoords(XPassed, YPassed);
			CardsCounter++;
		}
		RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
	}
}

void CTemporaryPile::SetReturnPoint(CColumn* CardsDest, std::string pType, int x, int y)
{
	StartX = x;
	StartY = y;
	SrcType = pType;
	CardsSrc = CardsDest;
}

void CTemporaryPile::SetMode(std::string Mode)
{
	this -> Mode = Mode;
}

std::string CTemporaryPile::GetMode()
{
	return Mode;
}

int CTemporaryPile::IsThisColumn(int MouseX, int MouseY, std::string Mode)
{
	return -1;
}
bool CTemporaryPile::GoodForThisColumn(std::list <CGameCard*> NewCards, 
									    std::string Src, std::string Mode)
{
	return false;
}
void CTemporaryPile::GetSrcPile(CColumn* &SrcPile, std::string &PileType)
{
	PileType = SrcType;
	*SrcPile = *CardsSrc; 
}

/****************************************************************/
/* CSourcePile                                                  */
/****************************************************************/

CSourcePile::CSourcePile() : CColumn ()
{
	this ->Type = "CSP"; 
}

CSourcePile::CSourcePile (int x0, int dx_pict, int dx_deck, int dx_max,
						  int y0, int dy_pict, int dy_deck, int dy_max, int column_ID) 
						  : CColumn (x0, dx_pict, dx_deck, dx_max,
							y0, dy_pict, dy_deck, dy_max, column_ID)
{
	 this ->Type = "CSP";
}
 
CSourcePile::~CSourcePile ()
{
}

int CSourcePile::IsThisColumn(int MouseX, int MouseY, std::string Mode)
{
	using namespace std;
	list <CGameCard*>::reverse_iterator C_Iter;
	if (Cards.empty())
	{
		if((MouseX >= x0)&&(MouseX <= x0 + CARDWIDTH))
		{
			if ((MouseY >= y0)&&(MouseY <= y0 + CARDHEIGHT))
				return 200;
		}
		return 0;
	}
	if ((dx_deck == 0) && (dy_deck == 0))
	{	
		C_Iter=Cards.rbegin ();
		CGameCard* Karta;
		Karta = (CGameCard*) *C_Iter;
		if(Karta->IsInside(MouseX, MouseY)) 
			return 1;	
	}
	else  
	{
		for(C_Iter=Cards.rbegin (); C_Iter!=Cards.rend (); C_Iter++)
		{
			CGameCard* Karta;
			Karta = (CGameCard*) *C_Iter;
			if(Karta->IsInside(MouseX, MouseY)) 
			{ 
				if((Mode == "To") || (C_Iter == Cards.rbegin ()))
					return 1; 
				else
					return -1;
			}
		}
	}	
	return 0;
}

bool  CSourcePile::GoodForThisColumn(std::list <CGameCard*> NewCards, std::string Src, 
									 std::string Mode)
{
	if((Mode == "ToColumn") && (Src == "CWP")) 
	{
		AddSubColumn(NewCards);
		return true;
	}
	return false;
}

/****************************************************************/
/* CWastePile                                                   */
/****************************************************************/
CWastePile::CWastePile() : CColumn ()
{
	 this ->Type = "CWP"; 
}

CWastePile::CWastePile (int x0, int dx_pict, int dx_deck, int dx_max,
						  int y0, int dy_pict, int dy_deck, int dy_max, 
						  int column_ID) : CColumn (x0, dx_pict, 
						   dx_deck, dx_max, y0, dy_pict, 
						   dy_deck, dy_max, column_ID)
{
	 this ->Type = "CWP";
}

int CWastePile::IsThisColumn(int MouseX, int MouseY, std::string Mode)
{
	using namespace std;
	list <CGameCard*>::reverse_iterator C_Iter;
	if (Cards.empty())
	{
		if((MouseX >= x0)&&(MouseX <= x0 + CARDWIDTH))
		{
			if ((MouseY >= y0)&&(MouseY <= y0 + CARDHEIGHT))
			{
				if(Mode == "To") return 1;
				return -1;
			}
		}
		return 0;
	}
	
	else  
	{
		for(C_Iter=Cards.rbegin (); C_Iter!=Cards.rend (); C_Iter++)
		{
			CGameCard* Karta;
			Karta = (CGameCard*) *C_Iter;
			if(Karta->IsInside(MouseX, MouseY)) 
			{ 
				if((Mode == "To") || (C_Iter==Cards.rbegin ()))
					return 1; 
				else
					return -1;
			}
		}
	}
	return 0;
}

bool  CWastePile::GoodForThisColumn(std::list <CGameCard*> NewCards, std::string Src, 
									std::string Mode)
{
	if((Src == "CSP") && (NewCards.size() == 1) && (Mode == "Mouse")) return true;
	return false;
}
 
CWastePile::~CWastePile ()
{
}

/****************************************************************/
/* CDestinationPile                                             */
/****************************************************************/

CDestinationPile::CDestinationPile() : CColumn ()
{
	 this ->Type = "CDP"; 
}

CDestinationPile::CDestinationPile (int x0, int dx_pict, int dx_deck, int dx_max,
						  int y0, int dy_pict, int dy_deck, int dy_max, 
						  int column_ID) : CColumn (x0, dx_pict, 
						   dx_deck, dx_max, y0, dy_pict, 
						   dy_deck, dy_max, column_ID)
{
	 this ->Type = "CDP";
}

int CDestinationPile::IsThisColumn(int MouseX, int MouseY, std::string Mode)
{
	using namespace std;
	list <CGameCard*>::reverse_iterator C_Iter;
	if (Cards.empty())
	{
		if((MouseX >= x0)&&(MouseX <= x0 + CARDWIDTH))
		{
			if ((MouseY >= y0)&&(MouseY <= y0 + CARDHEIGHT))
			{
				if(Mode == "To") return 1;
				return -1;
			}
		}
		return 0;
	}
	else  
	{
		for(C_Iter=Cards.rbegin (); C_Iter!=Cards.rend (); C_Iter++)
		{
			CGameCard* Karta;
			Karta = (CGameCard*) *C_Iter;
			if(Karta->IsInside(MouseX, MouseY)) 
			{ 
				if(Mode == "To") 
					return 1; 
				else
					return -1;
			}
		}
	}
	return 0;
}

bool  CDestinationPile::GoodForThisColumn(std::list <CGameCard*> NewCards, std::string Src, 
									std::string Mode)
{
	if((Src != "CSP") && (NewCards.size() == 1))
	{
		using namespace std;
		CGameCard* Karta;
		list <CGameCard*>::iterator C_Iter;
		C_Iter = NewCards.begin();
		Karta = (CGameCard*) *C_Iter;
		if(Cards.size() == 0) 
		{
			if((Karta ->  GetCardValue()) == 1) return true;
			return false;
		}
		CGameCard* LastCard;
		list <CGameCard*>::reverse_iterator R_Iter;
		R_Iter = Cards.rbegin();
		LastCard = (CGameCard*) *R_Iter;

		if(((Karta -> GetCardSuit()) == (LastCard -> GetCardSuit())) &&
			((Karta -> GetCardValue()) == (LastCard -> GetCardValue()) + 1))
			return true;
	}
	return false;
}

CDestinationPile::~CDestinationPile ()
{
}

/****************************************************************/
/* CReservePile                                                 */
/****************************************************************/

CReservePile::CReservePile() : CColumn ()
{
	 this ->Type = "RDP"; 
}

CReservePile::CReservePile (int x0, int dx_pict, int dx_deck, int dx_max,
						  int y0, int dy_pict, int dy_deck, int dy_max, 
						  int column_ID) : CColumn (x0, dx_pict, 
						   dx_deck, dx_max, y0, dy_pict, 
						   dy_deck, dy_max, column_ID)
{
	 this ->Type = "RDP";
}

CReservePile::~CReservePile ()
{
}

int CReservePile::IsThisColumn(int MouseX, int MouseY, std::string Mode)
{
	using namespace std;
	list <CGameCard*>::reverse_iterator C_Iter;
	if (Cards.empty())
	{
		if((MouseX >= x0)&&(MouseX <= x0 + CARDWIDTH))
		{
			if ((MouseY >= y0)&&(MouseY <= y0 + CARDHEIGHT))
				return -1;
		}
		return 0;
	}
	else  
	{
		for(C_Iter = Cards.rbegin (); C_Iter != Cards.rend (); C_Iter++)
		{
			CGameCard* Karta;
			Karta = (CGameCard*) *C_Iter;
			if(Karta -> IsInside(MouseX, MouseY)) 
			{ 
				if((Mode == "From") && (C_Iter==Cards.rbegin ()))
					return 1; 
				else
					return -1;
			}
		}
	}
	
	return 0;
}

bool CReservePile::GoodForThisColumn(std::list <CGameCard*> NewCards, 
									    std::string Src, std::string Mode)
{
	return false;
}

/****************************************************************/
/* CTableauPile                                                 */
/****************************************************************/

CTableauPile::CTableauPile() : CColumn ()
{
	 this ->Type = "TDP"; 
}

CTableauPile::CTableauPile (int x0, int dx_pict, int dx_deck, int dx_max,
						  int y0, int dy_pict, int dy_deck, int dy_max, 
						  int column_ID) : CColumn (x0, dx_pict, 
						   dx_deck, dx_max, y0, dy_pict, 
						   dy_deck, dy_max, column_ID)
{
	 this ->Type = "TDP";
}

CTableauPile::~CTableauPile ()
{
}

int CTableauPile::IsThisColumn(int MouseX, int MouseY, std::string Mode)
{
	using namespace std;
	list <CGameCard*>::reverse_iterator C_Iter;
	int CurrentValuePrev, CurrentValueNext;
	int Num = 0;
	SuitColors CurrentColorPrev, CurrentColorNext;
	if (Cards.empty())
	{
		if((MouseX >= x0)&&(MouseX <= x0 + CARDWIDTH))
		{
			if ((MouseY >= y0)&&(MouseY <= y0 + CARDHEIGHT))
			{
				if(Mode == "From") return -1;
				else return 1;
			}
		}
		return 0;
	}
	
	else  
	{
		for(C_Iter = Cards.rbegin(); C_Iter != Cards.rend(); C_Iter++)
		{
			CGameCard* Karta;
			Karta = (CGameCard*) *C_Iter;
			if (Mode == "From")  
			{
				if(C_Iter == Cards.rbegin())
				{
					CurrentValuePrev = Karta -> GetCardValue();
					CurrentColorPrev = Karta -> GetCardColor();
					Num++;
				}
				else
				{
					if(Num > 0)
					{
						CurrentValueNext = Karta -> GetCardValue();
						CurrentColorNext = Karta -> GetCardColor();
						if((CurrentValueNext != (CurrentValuePrev + 1)) || 
							(CurrentColorNext == CurrentColorPrev))
								Num = -1;
						else
						{
							CurrentValuePrev = CurrentValueNext;
							CurrentColorPrev = CurrentColorNext;
							Num++;
						}
					}
				}
			}
			if(Karta->IsInside(MouseX, MouseY)) 
			{ 
				if(Mode == "From")
					return Num; 
				else
					return 1;
			}
		}
	}
	return 0;
}

bool CTableauPile::GoodForThisColumn(std::list <CGameCard*> NewCards, 
									    std::string Src, std::string Mode)
{
	using namespace std;
	if(Cards.empty()) return true;
	list <CGameCard*>::reverse_iterator R_Iter;
	list <CGameCard*>::reverse_iterator R_Iter_New;
	CGameCard* Karta;
	CGameCard* Karta_New;
	R_Iter = Cards.rbegin();
	R_Iter_New = NewCards.rbegin();
	Karta = (CGameCard*) *R_Iter;
	Karta_New = (CGameCard*) *R_Iter_New;
	if((Karta_New -> GetCardValue() == (Karta -> GetCardValue() - 1)) && 
		(Karta_New -> GetCardColor() != Karta -> GetCardColor())) return true;
	return false;
}


/****************************************************************/
/* HStep                                                        */
/****************************************************************/

HStep::HStep(CColumn* FromColumn, CColumn* ToColumn, int NumOfCards,
			bool TurnMovingCard, bool TurnLastCardInColumn, bool OneByOne, int ID)
{
	this -> FromColumn = FromColumn;
	this -> ToColumn = ToColumn;
	this -> NumOfCards = NumOfCards;
	this -> TurnMovingCard = TurnMovingCard;
	this -> TurnLastCardInColumn = TurnLastCardInColumn;
	this -> OneByOne = OneByOne;
	this -> ID = ID;
}

bool HStep::Save(FILE* stream)
{
	if(NumOfCards == 0)
	{
		char str [100];
		sprintf (str, "FColumn: %d, TColumn: %d", (FromColumn -> GetColumnID()),
			(ToColumn -> GetColumnID()));
	}
	if(!SaveInt(FromColumn -> GetColumnID(), stream)) return false;
	if(!SaveInt(ToColumn -> GetColumnID(), stream)) return false;
	if(!SaveInt(NumOfCards, stream)) return false;
	if(!SaveInt((int)TurnMovingCard, stream)) return false;
	if(!SaveInt((int)TurnLastCardInColumn, stream)) return false;
	if(!SaveInt((int)OneByOne, stream)) return false;
	return true;
}

void HStep::GetInfo(CColumn* &FColumn, CColumn* &TColumn, int &Num, 
					bool &TM, bool &TC, bool &OBO)
{
	FColumn = FromColumn;
	TColumn = ToColumn;
	Num = NumOfCards;
	TM = TurnMovingCard;
	TC = TurnLastCardInColumn;
	OBO = OneByOne;
}
int HStep::GetID()
{
	return ID;
}

/****************************************************************/
/* StepHistory                                                  */
/****************************************************************/

StepHistory::StepHistory()
{
	CurrentStep = Steps.rbegin();
	LastStepID = -1;
}

bool StepHistory::AddStepToHistory(CColumn* FColumn, CColumn* TColumn, 
								   int Num, bool TC, bool TM,
								   bool OneByOne, HMENU hMenu)
{
	using namespace std;
	list <HStep*>::reverse_iterator R_Iter;
	list <HStep*>::reverse_iterator R_Iter_New;
	HStep* OneStep;

	if(Num == 0)
	{
		char str [100];
		sprintf ( str, "FColumn: %d, TColumn: %d", (FColumn -> GetColumnID()),
			(TColumn -> GetColumnID()));
	}
	if(!Steps.empty())
	{
		int CurrentStepID, OneStepID; 
		if(CurrentStep == Steps.rend()) CurrentStepID = -1;
		else
		{
		OneStep = (HStep*) *CurrentStep;
		CurrentStepID = OneStep -> GetID();
		}
		R_Iter = Steps.rbegin();
		if(CurrentStep != R_Iter)
		{
			OneStep = (HStep*) *R_Iter;
			OneStepID = OneStep -> GetID();
			while((OneStepID > CurrentStepID) && (!Steps.empty()))
			{
				Steps.remove(OneStep);
				delete OneStep;
				R_Iter_New = Steps.rbegin();
				LastStepID--;
				R_Iter = R_Iter_New;
				if(R_Iter == Steps.rend()) CurrentStepID = -1;
				else
				{
					OneStep = (HStep*) *R_Iter;
					OneStepID = OneStep -> GetID();	
				}
			}
			if((CurrentStep == Steps.rend()) && (Steps.empty())) 
			{
				MessageBox(NULL, "ERROR", "", NULL );
				return false;
			}
				
		}
	}
	LastStepID++;
	OneStep = new HStep(FColumn, TColumn, Num, TM, TC, OneByOne, LastStepID);
	Steps.push_back(OneStep);
	CurrentStep = Steps.rbegin();
	EnableMenuItem(hMenu, ID_MENU_REDO, MF_GRAYED);
	EnableMenuItem(hMenu, ID_MENU_UNDO, MF_ENABLED);
	return true;
}

int StepHistory::FindCurrentStepD()
{
	using namespace std;
	list <HStep*>::reverse_iterator R_Iter;
	if(Steps.empty()) return 0;
	else 
	{	list <HStep*>::reverse_iterator R_Iter;
		int CStepID = 0;
		R_Iter = Steps.rbegin();
		if(CurrentStep != R_Iter)
		{
			while((R_Iter != CurrentStep) && (R_Iter != Steps.rend()) )
			{
				CStepID++;
				R_Iter++;
			}
		}
		return CStepID;
	}
}
bool StepHistory::MakeOneStep(bool IsForward, CColumn* &FColumn, CColumn* &TColumn, 
				int &Num, bool &TM, bool &TC, bool &OBO, HMENU hMenu)
{	
	if(IsForward)
	{
		if(CurrentStep == Steps.rbegin()) return false;
		CurrentStep--;
		((HStep*) *CurrentStep) -> GetInfo(FColumn, TColumn, Num, TM, TC, OBO);
		if(CurrentStep == Steps.rbegin()) 
		{
			EnableMenuItem(hMenu, ID_MENU_REDO, MF_GRAYED);
		}
		EnableMenuItem(hMenu, ID_MENU_UNDO, MF_ENABLED);
	}

	else
	{
		if(CurrentStep == Steps.rend()) return false;
		((HStep*) *CurrentStep) -> GetInfo(FColumn, TColumn, Num, TM, TC, OBO);
		CurrentStep++;
		EnableMenuItem(hMenu, ID_MENU_REDO, MF_ENABLED);
		if(CurrentStep == Steps.rend())
			EnableMenuItem(hMenu, ID_MENU_UNDO, MF_GRAYED);
	}
	return true;
}

bool StepHistory::Save(FILE* stream)
{
	using namespace std;
	HStep* OneStep;
	list <HStep*>::iterator C_Iter;

	if(!SaveInt(Steps.size(), stream)) return false;
	int CStepD;
	CStepD = FindCurrentStepD();
	if(!SaveInt(CStepD, stream)) return false;
	for(C_Iter = Steps.begin(); C_Iter != Steps.end(); C_Iter++)
	{
		OneStep = (HStep*) *C_Iter;
		if(!OneStep -> Save(stream))return false;
	}
	return true;
}
bool FindAddress(int ColumnID, CColumn* &ResColumn, 
				 std::list <CColumnAddress*> ColumnIDs)
{
	using namespace std;
	if((ColumnID < 0) || (ColumnID >= ColumnIDs.size())) return false;
	list <CColumnAddress*>::iterator C_Iter;
	CColumnAddress* CurrentAddress;
	bool res = false;
	C_Iter = ColumnIDs.begin();
	int i;
	for(i = 0; i < ColumnID; i++) C_Iter++;
	CurrentAddress = (CColumnAddress*) *C_Iter;
	if(CurrentAddress -> GetID() == ColumnID) 
	{
		ResColumn = CurrentAddress -> GetAddress();
		res = true;
	}
	return res;
}
bool StepHistory::Load(FILE* stream, std::list <CColumnAddress*> ColumnIDs,
					   int NumOfHistorySteps)
{
	int i;
	int CStepD;
	bool res = true;
	CColumn* FColumn;
	CColumn* TColumn;
	HStep* OneStep;
	int FColumnID, TColumnID, Num, iTC, iTM, iOneByOne;
	ClearHistory();
	if(!ReadInt(CStepD, stream)){LastStepID = -1;  return false;}
	LastStepID = 0;
	for(i = 0; i < NumOfHistorySteps; i++)
	{
		if(!ReadInt(FColumnID, stream)) res = false;
		if(!res)break;
		res = FindAddress(FColumnID, FColumn, ColumnIDs);
		if(!res)break;
		if(!ReadInt(TColumnID, stream)) res = false;
		if(!res)break;
		res = FindAddress(TColumnID, TColumn, ColumnIDs);
		if(!res)break;
		if(!ReadInt(Num, stream)) res = false;
		if(!res)break;
		res = ((Num > 0) && (Num <= NUMBER_OF_CARDS_IN_DECK));
		if(!res)
		{
			int res1, Num1;
			if(!ReadInt(Num1, stream)) res1 = false;
			break;
		}
		if(!ReadInt(iTM, stream)) res = false;
		if(!res)break;
		if(!ReadInt(iTC, stream)) res = false;
		if(!res)break;
		if(!ReadInt(iOneByOne, stream)) res = false;
		if(!res)break;
		OneStep = new HStep(FColumn, TColumn, Num, (bool)iTM, (bool)iTC, 
			(bool)iOneByOne, LastStepID);
		Steps.push_back(OneStep);
		LastStepID++;
		CurrentStep = Steps.rbegin();
	}
	if(CStepD <= Steps.size()) 
	{
		for(i = 0; i < CStepD; i++)CurrentStep++;
	}
	return res;
}
void StepHistory::SetHistoryMenu(HMENU hMenu)
{
	if(CurrentStep == Steps.rbegin())
		 EnableMenuItem(hMenu, ID_MENU_REDO, MF_GRAYED);
	else EnableMenuItem(hMenu, ID_MENU_REDO, MF_ENABLED);
	if(CurrentStep == Steps.rend/*begin*/())
		 EnableMenuItem(hMenu, ID_MENU_UNDO, MF_GRAYED);
	else EnableMenuItem(hMenu, ID_MENU_UNDO, MF_ENABLED);
}
void StepHistory::ClearHistory()
{
	using namespace std;
	HStep* OneStep;
	list <HStep*>::reverse_iterator R_Iter;

	while(!Steps.empty())
	{
		R_Iter = Steps.rbegin();
		OneStep = (HStep*) *R_Iter;
		Steps.remove(OneStep);
		delete OneStep;
	}
	CurrentStep = Steps.rend();
	LastStepID = -1;
}

StepHistory::~StepHistory()
{
	using namespace std;
	HStep* OneStep;
	list <HStep*>::reverse_iterator R_Iter;

	while(!Steps.empty())
	{
		R_Iter = Steps.rbegin();
		OneStep = (HStep*) *R_Iter;
		Steps.remove(OneStep);
		delete OneStep;
	}
}


/****************************************************************/
/* CGame                                                        */
/****************************************************************/

void CGame::StandardMotion(CColumn* Src, CColumn* Dst, int Num, HWND hWnd, 
						   int OpenLast, bool TurnMoving, bool OneByOne, bool ToAdd,
						   HMENU hMenu)
{
	using namespace std;
	int NewX, NewY;
	string CType;
	if(OneByOne)
	{
		for(int i = 0; i < Num; i++)
		{
			TempPile.SetTemporaryPile(Src, 1, "ToSource");
			Dst -> GetNextCardCoords(NewX, NewY);
			CType = Dst -> GetType();
			TempPile.SetReturnPoint(Dst, CType, NewX, NewY);
			TempPile.ReturnTemporaryPile(hWnd, TurnMoving);	
		}
	}
	else
	{
		TempPile.SetTemporaryPile(Src, Num, "ToSource");
		Dst -> GetNextCardCoords(NewX, NewY);
		CType = Dst -> GetType();
		TempPile.SetReturnPoint(Dst, CType, NewX, NewY);
		TempPile.ReturnTemporaryPile(hWnd, TurnMoving);
	}
	if(OpenLast > 0) Src -> OpenLastCards(OpenLast);
	if(ToAdd) 
		History.AddStepToHistory(Src, Dst, Num, (OpenLast > 0), TurnMoving, OneByOne, hMenu);
}

void CGame::ResetColumns()
{
	using namespace std;
	list <CColumn*>::iterator C_Iter;
	for(C_Iter = Columns.begin(); C_Iter != Columns.end(); C_Iter++)
		(*C_Iter) -> ColumnReset();
}
void CGame::NewGame(std::string Mode, HWND hWnd, HMENU hMenu, bool &PictOn)
{
	using namespace std;
	list <CGameCard*> SomeCards;
	
	History.ClearHistory();
	EnableMenuItem(hMenu, ID_MENU_UNDO, MF_GRAYED);
	EnableMenuItem(hMenu, ID_MENU_REDO, MF_GRAYED);
	ResetColumns();
	if(Mode == "New") 
		SetOf52.NewSort();
	else SetOf52.Restart();
	
	list <CColumn*>::iterator C_Iter;
	C_Iter = Columns.begin();
	C_Iter++;
	for(int i=0; i < 9; i++)
	C_Iter++;

	for(i = 0; i < 8; i++)
	{
		SetOf52.CardsToColumn(4, SomeCards);
		OpenLastCards(SomeCards, 4);
		(*C_Iter) -> AddSubColumn(SomeCards);
		SomeCards.clear();
		C_Iter++;
	}

	SetOf52.CardsToColumn(30, SomeCards);
	(*C_Iter) -> AddSubColumn(SomeCards);
	(*C_Iter) -> OpenLastCards(1);
	SomeCards.clear();

	C_Iter = Columns.begin();
	SetOf52.CardsToColumn(/*104*/NUMBER_OF_CARDS_IN_DECK, SomeCards);
	(*C_Iter) -> AddSubColumn(SomeCards);
	SomeCards.clear();

	TempPile.SetMode("ToColumn");
	bool res;
	do
	{
		res = AutoStep(hWnd, hMenu, PictOn);
		RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
	}while (res);
	TempPile.SetMode("Mouse");
}

bool CGame::Save()
{
	using namespace std;
	
	list <CColumn*>::iterator C_Iter;
	CColumn* Stb;
	FILE *stream;
	bool res;

	stream = fopen(GetSaveFile().c_str(), "wb");
	if(stream == NULL) return false;

	res = SetOf52.Save(stream); 
	for(C_Iter = Columns.begin (); C_Iter!=Columns.end (); C_Iter++)
	{
		if(!res) break;
		Stb = (CColumn*) *C_Iter;
		res = (Stb -> Save(stream));
	}

	if(res) res = History.Save(stream);
	fclose (stream);
	fcloseall();
	return res;
}


bool CGame::GetSuccess()
{
	return LoadSuccess;
}
void CGame::SetSuccess(bool sc)
{
	LoadSuccess = sc;
}

bool CGame::CreateColumnAddressTable(std::list <CColumnAddress*> &IDList)
{
	using namespace std;
	list <CColumn*>::iterator C_Iter;
	CColumnAddress* NewAddress; 
	int id = 0;
	bool res = true;
	IDList.clear();
	for(C_Iter = Columns.begin (); C_Iter!=Columns.end (); C_Iter++)
	{
		NewAddress = new CColumnAddress(id, (*C_Iter));
		if(NewAddress == NULL)
		{
			res = false;
			break;
		}
		else IDList.push_back(NewAddress);
		id++;
	}
	return res;
}
void DeleteColumnAddressTable(std::list <CColumnAddress*> &IDList)
{
	using namespace std;
	list <CColumnAddress*>::iterator C_Iter;
	for(C_Iter = IDList.begin (); C_Iter!=IDList.end (); C_Iter++)
		delete (*C_Iter);
	IDList.clear();
}
CGame::CGame()
{
	using namespace std;
	list <CColumnAddress*> ColumnIDs;
	list <CColumn*>::iterator C_Iter;
	CColumn* Stb;
	int NumOfHistorySteps;
	FILE *stream;
	bool IsOpened;

	sprintf ( PictName, "");
	stream = fopen(GetSaveFile().c_str(), "rb");
	AddressTable.clear();
	if(stream == NULL)
	{
		LoadSuccess = false;
		IsOpened = false;
		SetOf52.Init();
	}
	else
	{
		LoadSuccess = SetOf52.Load(stream, AddressTable);//Init();
		IsOpened = true;
	}
	if(LoadSuccess && AddressTable.empty())
	{
		LoadSuccess = false;
	}
	int StartY =10; 
	CSourcePile *SPile = new CSourcePile;
	Columns.push_back(SPile);
	CWastePile *WPile = new CWastePile (124, 15, 5, 15000, StartY, 0, 0, 15000, 1);
	Columns.push_back(WPile);
	CDestinationPile *DPile;
	for(int i = 0; i < 8; i++)
	{
		DPile = new CDestinationPile (30 + 94*i, 0, 5, 15000, StartY + 95, 0, 0, 15000, i+2);
		Columns.push_back(DPile);
	}

	for(i = 0; i < 4; i++)
	{
		CTableauPile *TPile = new CTableauPile (240, -15, -5, 10, 
			StartY + 190 + (CARDHEIGHT + 5) * i, 0, 0, 15000, 10 + i);
		Columns.push_back(TPile);
	}

	for(i = 0; i < 4; i++)
	{
		CTableauPile *TPile = new CTableauPile (500, 15, 5, 1200, 
			StartY + 190 + (CARDHEIGHT + 5) * i, 0, 0, 15000, 14 + i);
		Columns.push_back(TPile);
	}
	
	CReservePile *RPile = new CReservePile (310, 0, 0, 15000, StartY + 190, 30, 27, 460, 18);
	Columns.push_back(RPile);
	if (LoadSuccess)
	{
		for(C_Iter = Columns.begin (); C_Iter!=Columns.end (); C_Iter++)
		{
			if(!LoadSuccess) break;
			Stb = (CColumn*) *C_Iter;
			LoadSuccess = (Stb -> Load(stream, AddressTable));
		}
	}
	if (LoadSuccess)ReadInt(NumOfHistorySteps, stream);
	if(LoadSuccess) 
	{
		if(NumOfHistorySteps > 0)
		{
			ColumnIDs.clear();
			LoadSuccess = CreateColumnAddressTable(ColumnIDs);
			if(LoadSuccess)LoadSuccess = (ColumnIDs.size() == Columns.size());
			if(LoadSuccess)LoadSuccess = History.Load(stream, ColumnIDs, NumOfHistorySteps);
			DeleteColumnAddressTable(ColumnIDs);
		}
	}
	if(LoadSuccess)
	{
		LoadSuccess = !CheckWin(false);
	}
	if (IsOpened) fclose (stream);
}
void CGame::SetHistoryMenu(HMENU hMenu)
{
	History.SetHistoryMenu(hMenu);
}

int CGame::GetRandomPictName()
{
	srand((unsigned)time( NULL ));
	int r = rand();
	int j = RAND_MAX;
	int res = (int) (r * NUMBER_OF_PICTURES / j);
	if(res < NUMBER_OF_PICTURES) res++;
	return res;
}

void CGame::Draw(HDC h, int x0_screen, int y0_screen, int xl_screen, int yl_screen,
				 bool DrawPict)
{
	RECT rt;
	rt.top=x0_screen;
	rt.left=y0_screen;
	rt.bottom=yl_screen;
	rt.right=xl_screen;
	HDC hMemDC = CreateCompatibleDC ( h );
	
	if(DrawPict)
	{
		HBITMAP hMemBmp = LoadBitmap(ghInstance, PictName);
		SelectObject (hMemDC, hMemBmp);
		BitBlt (h, x0_screen, y0_screen, 1000, 1000, hMemDC, 0, 0, SRCCOPY);
		DeleteDC (hMemDC);
		DeleteObject (hMemBmp);
	}   
	else
	{
		HBITMAP hMemBmp = CreateCompatibleBitmap ( h, xl_screen, yl_screen );
		HBITMAP hOld = (HBITMAP)SelectObject ( hMemDC, hMemBmp );
		FillRect(hMemDC,&rt,GetSysColorBrush(COLOR_BACKGROUND+2));

		using namespace std;
		if(!Columns.empty())
		{
			list <CColumn*>::iterator C_Iter;
			for(C_Iter=Columns.begin (); C_Iter!=Columns.end (); C_Iter++)
				(*C_Iter)->Draw(hMemDC);  
		}
		if (TempPile.IsVisible()) TempPile.Draw(hMemDC);
		BitBlt (h, x0_screen, y0_screen, xl_screen, yl_screen, hMemDC, 0, 0, SRCCOPY);
	SelectObject(hMemDC,hOld);
	DeleteObject(hMemBmp);
	DeleteDC (hMemDC);
	}
}

bool CGame::CheckWin(bool Mes)
{
	using namespace std;
	list <CColumn*>::iterator C_Iter;
	CColumn* Stb;
	std::string StbType;
	int Num;
	for(C_Iter = Columns.begin (); C_Iter!=Columns.end (); C_Iter++)
	{
		Stb = (CColumn*) *C_Iter;
		StbType = Stb -> GetType();
		if(StbType != "CDP") continue;
		Num = Stb -> NumOfCardsInColumn();
		if(Num < NUMBER_OF_CARDS_IN_SUIT) return false;
	}
	if(Mes) MessageBox(NULL, "YOU WIN!", "You Win!", NULL );
	int pNum = GetRandomPictName();
	sprintf ( PictName, "IDB_BILL%d", pNum );
	return true;
}

bool CGame::AutoStep(HWND hWnd, HMENU hMenu, bool &PictOn)
{
	using namespace std;
	list <CColumn*>::reverse_iterator R_Iter;
	list <CColumn*>::iterator C_Iter;
	CColumn* Stb;
	std::string StbType;
	int MinValueRed = NUMBER_OF_CARDS_IN_SUIT, 
		MinValueBlack = NUMBER_OF_CARDS_IN_SUIT;
	int LastValue, CurrentValue;
	Suits LastSuit, CurrentSuit;
	int i = 0;
	int NumberOfRedDest = 0, NumberOfBlackDest = 0;
	int Last;
	bool Res = false;
	
	for(C_Iter = Columns.begin (); C_Iter!=Columns.end (); C_Iter++)
	{
		Stb = (CColumn*) *C_Iter;
		StbType = Stb -> GetType();
		if(StbType == "CDP")
		{
			if(i >= 8) break;
			DstArray[i].DColumn = Stb;
			if(Stb -> IsEmpty ()) 
			{
				DstArray[i].Value = 0;
				
			}
			else
			{ 
				Stb -> GetLastCardValueAndSuit(LastValue, LastSuit);
				DstArray[i].Value = LastValue;
				DstArray[i].Suit = LastSuit;
				if (GetColor(LastSuit) == Red) 
				{
					NumberOfRedDest++;
					if(LastValue < MinValueBlack) MinValueBlack = LastValue;
				}
				else 
				{
					NumberOfBlackDest++;
					if(LastValue < MinValueRed) MinValueRed = LastValue;
				}
			}
			i++;
		}
	}
	if(NumberOfRedDest < 4) MinValueBlack = 2; 
	else MinValueBlack += 2;

	if(NumberOfBlackDest < 4) MinValueRed = 2;
	else MinValueRed += 2;
	for(R_Iter = Columns.rbegin (); R_Iter != Columns.rend (); R_Iter++)
	{
		Stb = (CColumn*) *R_Iter;
		StbType = Stb -> GetType();
		if((Stb -> IsEmpty ()) || (StbType == "CSP") || (StbType == "CDP"))
			continue;
		Stb -> GetLastCardValueAndSuit(CurrentValue, CurrentSuit);
		if ((GetColor(CurrentSuit) == Red) && (CurrentValue <= MinValueRed) ||
			(GetColor(CurrentSuit) == Black) && (CurrentValue <= MinValueBlack))
		{
			for(i = 0; i < 8; i++)
			{
				if(((CurrentValue == 1) && (DstArray[i].Value == 0)) || 
					((CurrentValue == DstArray[i].Value + 1) && 
						(CurrentSuit == DstArray[i].Suit)))
				{
					if((Stb -> GetType() == "RDP")) Last = 1;
					else Last = 0;
					StandardMotion(Stb, DstArray[i].DColumn, 1, hWnd, Last, 
							       false, false, true, hMenu);
					if(DstArray[i].Value == -1)
					{
						DstArray[i].Value = 1;
						DstArray[i].Suit = CurrentSuit;
					}
					else DstArray[i].Value++;
					return true;
				}
			}
		}	
	}
	if(CheckWin(true)) PictOn = true;
	return false;
}

bool CGame::MakeOneStep(bool IsForward, HWND hWnd, HMENU hMenu)
{
	using namespace std;
	CColumn* FColumn, *TColumn;
	int Num;
	bool TurnM, TurnL, OneB;
	int OpenLast;
	string CType;

	if(!History .MakeOneStep(IsForward, FColumn, TColumn, Num, TurnM, TurnL, OneB, hMenu)) 
		return false;
	if (TurnL) OpenLast = 1; else OpenLast = 0;
	if(IsForward)
		StandardMotion(FColumn, TColumn, Num, hWnd, OpenLast, TurnM, OneB, false, hMenu);
	else 
	{
		if(OpenLast != 0) FColumn -> OpenLastCards(OpenLast);
		StandardMotion(TColumn, FColumn, Num, hWnd, false, TurnM, OneB, false, hMenu);
	}
	return true;
}

CGame::~CGame()
{
	using namespace std;
	list <CColumn*>::iterator C_Iter;
	for(C_Iter = Columns.begin(); C_Iter != Columns.end(); C_Iter++)
	  delete (*C_Iter);
}

bool CGame::TemporaryPileIsAvailable()
{
	if (TempPile.GetMode() == "Mouse") return true;
	return false;
}

bool CGame::FindStep(int Num, CColumn* ThisStb, CColumn* &ResultStb)
{
	using namespace std;
	list <CGameCard*> SomeCards;
	list <CColumn*>::iterator C_Iter, C1_Iter;
	list <CGameCard*>::iterator Card_Iter;
	CColumn* ItStb;
	CColumn* ReserveStb = NULL;

	ThisStb -> GetSubColumnList(Num, SomeCards);
	string StbType = ThisStb -> GetType();
	for(C_Iter = Columns.begin (); C_Iter != Columns.end (); C_Iter++)
	{
		ItStb = (CColumn*) *C_Iter;
		
		if(ItStb == ThisStb) continue;
		if(StbType == "CSP")
		{
			if((ItStb -> GetType()) == "CWP") 
			{
				SomeCards.clear();
				ResultStb = ItStb;
				return true;
			}
				else continue;
		} 
		
		if(StbType == "CWP")
			if((ItStb -> GetType()) == "CSP") continue;

		if(ItStb -> GoodForThisColumn(SomeCards, StbType, "ToColumn"))
		{
			if(((ItStb -> GetType()) == "TDP") && (ItStb -> IsEmpty()))
			{
				if(ReserveStb == NULL) ReserveStb = ItStb;
				continue;
			}
			SomeCards.clear();
			ResultStb = ItStb;
			return true;
		}
	}
	ResultStb = ReserveStb;
	return (ResultStb != NULL);
}

bool CGame::GetCardsToMove(int PrevX, int PrevY, HWND hWnd, HMENU hMenu, std::string Mode)
{
	using namespace std;
	string StbType;
	int res = 0;
	list <CGameCard*> SomeCards;
	list <CColumn*>::iterator C_Iter, C1_Iter;
	CColumn* Stb; 
	CColumn* Stb1;
	bool TurnM;

	C_Iter = Columns.begin ();
	while ((res == 0) && ((C_Iter != Columns.end())))
	{
		res = (*C_Iter) -> IsThisColumn(PrevX, PrevY, "From");
		if (res > 0)
		{
			Stb = (CColumn*) *C_Iter;

			string StbType = Stb -> GetType();
			if((StbType == "CSP") && (res > 52))
			{
				for(C1_Iter = Columns.begin(); C1_Iter != Columns.end(); C1_Iter++)
				{
					Stb1 = (CColumn*) *C1_Iter;
					std::string Stb1Type = Stb1 -> GetType();
					if (Stb1Type == "CWP") break;
				}
				int Num =  Stb1 -> NumOfCardsInColumn();
				StandardMotion(Stb1, Stb, /*1*/Num, hWnd, 0, true, true, true, hMenu);
				TempPile.SetMode("Mouse");
				return false;
			}
			if(Mode == "FindStep") 
			{
				if (FindStep(res, Stb, Stb1))
				{
					bool OpenLast;
					if((Stb -> GetType() == "RDP")) OpenLast = true;
					else OpenLast = false;
					if((Stb -> GetType() == "CSP") || (Stb1 -> GetType() == "CSP"))
						TurnM = true; 
					else TurnM = false;
					StandardMotion(Stb, Stb1, res, hWnd, OpenLast, TurnM,
						TurnM, true, hMenu);
					RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
					return true;
				}
				else return false; 
			}
			else
				TempPile.SetTemporaryPile(Stb, res, "Mouse");
		}
		C_Iter++;
	}
	if (res) return true; 
	return false;
}

bool CGame::TemporaryPileIsVisible()
{
	return TempPile.IsVisible();
}

void CGame::ChangeCoordsOfTemporaryPile(int dx, int dy)
{
	TempPile.MoveColumnBy(dx, dy);	
}

void CGame::EndOfMovement(int PrevX, int PrevY, bool &nAutoStep, HWND hWnd, HMENU hMenu)
{
	TempPile.SetMode ("ToColumn");
	using namespace std;
	list <CColumn*>::iterator C_Iter;
	string PileName;
	CColumn* Stb;
	CColumn* Stb_Prev;
	C_Iter = Columns.begin ();
	list <CGameCard*> SomeCards;
	int NewX, NewY;
	int Num, res = 0;
	bool TurnM = false;
	bool OpenLast = false;
	bool ToHistory = false;
	nAutoStep = false;
	while ((res == 0) && ((C_Iter != Columns.end())))
	{
		res = (*C_Iter) -> IsThisColumn(PrevX, PrevY, "To");
		if (res > 0)
		{
			Stb = (CColumn*) *C_Iter;
			TempPile.GetFromTemporaryPile(Stb_Prev, SomeCards, PileName);
			if(Stb ->GoodForThisColumn(SomeCards, PileName,"Mouse"))
			{
				nAutoStep = true;
				Stb -> GetNextCardCoords(NewX, NewY);
				PileName = Stb -> GetType();
				if(Stb_Prev -> GetType() == "CSP") TurnM = true;
				Num = TempPile.NumOfCardsInColumn();
				TempPile.SetReturnPoint(Stb, PileName, NewX, NewY);  
				if((Stb_Prev -> GetType()) == "RDP") OpenLast = true;
				ToHistory = true;
			}
		}
		C_Iter++;
	}
	TempPile.ReturnTemporaryPile(hWnd, TurnM);
	if(OpenLast) Stb_Prev -> OpenLastCards(1);
	if(ToHistory) History.AddStepToHistory(Stb_Prev, Stb, Num, OpenLast, TurnM, TurnM, hMenu);  
	RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
}

void CGame::ReturnCardsOnAlert(HWND hWnd)
{
	TempPile.ReturnTemporaryPile(hWnd, false);
}













