#ifndef _OBJECTS_H_
#define _OBJECTS_H_

#include <windows.h>
#include <list>

enum Suits {Club, Diamond, Heart, Spade};
enum SuitColors {Red, Black};

class CGameCard 
{
	protected:
		int Value;
		Suits Suit;
		bool IsFaceUp;
		char PictName[15];
		int ID;

	public:
		int xl, yl;
		int x0, y0;
		CGameCard(int x0, int y0, int xl, int yl, int v, Suits s, int ID);
		CGameCard();
		bool IsInside(int x, int y);
		bool Side();
		void ChangeCoordsBy(int dx, int dy);
		void Draw(HDC h);
		RECT GetCardCoords();
		void GetCardCoords(int &x, int &y);
		void SetCardCoords(int NewX, int NewY);
		void SetSide(bool s);
		void ReverseSide();
		int GetCardValue();
		Suits GetCardSuit();
		SuitColors GetCardColor();
		int GetCardID();
		void CardReset();
};

class CCardAddress
{
		int CardID;
		CGameCard* Addr;
		bool Used;
	public:
		CCardAddress(int  CardID, CGameCard* Addr);
		int GetID();
		CGameCard* GetAddress();
		~CCardAddress();
};
class CAllCards 
{
	private:
		CGameCard* AllCards[104]; 
		int Used;
	public:
		void Init();
		~CAllCards();
		int NumOfCards();
		void CardsToColumn(int NumberOfCards, std::list <CGameCard*> &ToColumn);
		void NewSort();
		void Restart();
		bool Save(FILE* stream);
		bool Load(FILE* stream, std::list <CCardAddress*> &UsedIDs);
		void RepairAllCardsList(std::list <int> &IDList);
};

class CColumn
{
protected:
	std::list <CGameCard*> Cards;
	int x0;
	int dx_pict;
	int dx_deck;
	int dx_max;
	int y0;
	int dy_pict;
	int dy_deck;
	int dy_max;
	std::string Type;
	int column_ID;
public:
	CColumn (int x0, int dx_pict, int dx_deck, int dx_max,
		int y0, int dy_pict, int dy_deck, int dy_max, int column_ID);
	CColumn();
	void AddCard (CGameCard* pObj);
	void AddSubColumn (std::list <CGameCard*> NewCards);
	void Draw (HDC h);
	void GetSubColumnToMove(std::list <CGameCard*> &NewCards, int &x, int &x_pict, 
					int &y,	int &y_pict, std::string &pType, int NumOfCardsToMove);
	CGameCard* GetCardToMove(int MouseX, int MouseY);
	virtual int IsThisColumn(int MouseX, int MouseY, std::string Mode) = 0;
	virtual bool GoodForThisColumn(std::list <CGameCard*> NewCards, std::string Src, 
									std::string Mode) = 0;
	virtual ~CColumn ();
	std::string GetType();
	void MoveColumnBy(int dx, int dy);
	int NumOfCardsInColumn();
	void GetNextCardCoords(int &NewX, int &NewY);
	void OpenLastCards (int NumOfCards);
	void ColumnReset();
	void OnlyTest();
	bool IsEmpty();
	bool GetLastCardValueAndSuit(int &v, Suits &s);
	void GetSubColumnList(int NumOfCards, std::list <CGameCard*> &NewCards);
	int GetColumnID();
	bool Save(FILE* stream);
	bool Load(FILE* stream, std::list <CCardAddress*> &UsedIDs);
};

class CTemporaryPile : public CColumn
{
	private:
		std::string SrcType;
		std::string Mode;
		int StartX;
		int StartY;
		bool Visible;
		CColumn* CardsSrc;
	public:
		CTemporaryPile();
		bool IsVisible();
		void SetTemporaryPile(CColumn* CardsSrc, int NumOfCards, std::string Mode);
		void GetFromTemporaryPile(CColumn* &SrcPile, std::list <CGameCard*> &ToColumn, 
										std::string &PileType/*, int Num*/);
		void ResetTemporaryPile();
		void ReturnTemporaryPile(HWND hWnd, bool TurnMoving);
		int IsThisColumn(int MouseX, int MouseY, std::string Mode);
		bool GoodForThisColumn(std::list <CGameCard*> NewCards, std::string Src, 
								std::string Mode);
		void SetReturnPoint(CColumn* CardsDest, std::string pType, int x, int y);
		void SetMode(std::string Mode);
		std::string GetMode();
		void GetSrcPile(CColumn* &SrcPile, std::string &PileType);
};

class CSourcePile : public CColumn
{
	public:
		CSourcePile();
		CSourcePile(int x0, int dx_pict, int dx_deck, int dx_max,
			int y0, int dy_pict, int dy_deck, int dy_max, int column_ID);
		~CSourcePile (); 
		int IsThisColumn(int MouseX, int MouseY, std::string Mode);
		bool GoodForThisColumn(std::list <CGameCard*> NewCards, std::string Src, 
								std::string Mode);
};

class CWastePile : public CColumn

{
	public:
		CWastePile();
		CWastePile(int x0, int dx_pict, int dx_deck, int dx_max,
			int y0, int dy_pict, int dy_deck, int dy_max, int column_ID);
		~CWastePile (); 
		void MoveToSourcePile();
		int IsThisColumn(int MouseX, int MouseY, std::string Mode);
		bool GoodForThisColumn(std::list <CGameCard*> NewCards, std::string Src, 
								std::string Mode);
};

class CDestinationPile : public CColumn

{
	public:
		CDestinationPile();
		CDestinationPile(int x0, int dx_pict, int dx_deck, int dx_max,
			int y0, int dy_pict, int dy_deck, int dy_max, int column_ID);
		~CDestinationPile ();
		int IsThisColumn(int MouseX, int MouseY, std::string Mode);
		bool GoodForThisColumn(std::list <CGameCard*> NewCards, std::string Src, 
								std::string Mode);
};

class CReservePile : public CColumn

{
	public:
		CReservePile();
		CReservePile(int x0, int dx_pict, int dx_deck, int dx_max,
			int y0, int dy_pict, int dy_deck, int dy_max, int column_ID);
		~CReservePile (); 
		int IsThisColumn(int MouseX, int MouseY, std::string Mode);
		bool GoodForThisColumn(std::list <CGameCard*> NewCards, std::string Src, 
								std::string Mode);
};

class CTableauPile : public CColumn

{
	public:
		CTableauPile();
		CTableauPile(int x0, int dx_pict, int dx_deck, int dx_max,
			int y0, int dy_pict, int dy_deck, int dy_max, int column_ID);
		~CTableauPile (); 
		int IsThisColumn(int MouseX, int MouseY, std::string Mode);
		bool GoodForThisColumn(std::list <CGameCard*> NewCards, std::string Src, 
								std::string Mode);
};

struct SDstColumn
{
	CColumn* DColumn;
	int Value;
	Suits Suit;
};
class CColumnAddress
{
		int ColumnID;
		CColumn* Addr;
	public:
		CColumnAddress(int  ColumnID, CColumn* Addr);
		int GetID();
		CColumn* GetAddress();
};
class HStep
{
	protected:
		CColumn* FromColumn;
		CColumn* ToColumn;
		int NumOfCards;
		bool TurnMovingCard;
		bool TurnLastCardInColumn;
		bool OneByOne;
		int ID;
	public:
		HStep(CColumn* FromColumn, CColumn* ToColumn, int NumOfCards,
			bool TurnMovingCard, bool TurnLastCardInColumn, bool OneByOne, int ID);
		void GetInfo(CColumn* &FColumn, CColumn* &TColumn, int &Num, 
			bool &TM, bool &TC, bool &OBO);
		int GetID();
		bool Save(FILE* stream);
};

class StepHistory
{
	protected:
		std::list <HStep*> Steps;
		std::list <HStep*>::reverse_iterator CurrentStep;
		int LastStepID;
	public:
		StepHistory();
		bool AddStepToHistory(CColumn* FColumn, CColumn* TColumn,
			int Num, bool TC, bool TM, bool OneByOne, HMENU hMenu);
		int FindCurrentStepD();
		bool MakeOneStep(bool IsForward, CColumn* &FColumn, CColumn* &TColumn, 
			int &Num, bool &TM, bool &TC, bool &OBO, HMENU hMenu);
		bool Save(FILE* stream);
		bool Load(FILE* stream, std::list <CColumnAddress*> ColumnIDs,
					int NumOfHistorySteps);
		void SetHistoryMenu(HMENU hMenu);
		void RemoveSteps(int NumOfSteps);
		void ClearHistory();
		~StepHistory();
}; 

class CGame
{
	protected:
		CTemporaryPile TempPile;
		std::list <CColumn*> Columns;
		CAllCards SetOf52;
		SDstColumn DstArray[8];
		StepHistory History;
		bool LoadSuccess;
		std::list <CCardAddress*> AddressTable;
		char PictName[15];
	public:
		CGame();
		int GetRandomPictName();
		bool GetSuccess();
		void SetSuccess(bool sc);
		void NewGame(std::string Mode, HWND hWnd, HMENU hMenu, bool &PictOn);
		bool Save();
		bool CreateColumnAddressTable(std::list <CColumnAddress*> &ColumnIDs);
		bool LoadGame(HWND hWnd);
		void SetHistoryMenu(HMENU hMenu);
		void Draw(HDC h, int x0_screen, int y0_screen, int xl_screen, int yl_screen, bool DrawPict);
		bool GetCardsToMove(int PrevX, int PrevY, HWND hWnd, HMENU hMenu, std::string Mode);
		bool TemporaryPileIsVisible();
		void ChangeCoordsOfTemporaryPile(int dx, int dy);
		void PlaceTempPile();
		bool TemporaryPileIsAvailable();
		void ReturnCardsOnAlert(HWND hWnd);
		void EndOfMovement(int PrevX, int PrevY, bool &nAutoStep, HWND hWnd, HMENU hMenu); 
		void ResetColumns();
		bool AutoStep(HWND hWnd, HMENU hMenu, bool &PictOn);
		bool FindStep(int Num, CColumn* ThisStb, CColumn* &ResultStb);
		bool FindColumnByCoord(CColumn* &FoundColumn, int &Num, HMENU hMenu);
		bool MakeOneStep(bool IsForward, HWND hWnd, HMENU hMenu);
		void StandardMotion(CColumn* Src, CColumn* Dst, int Num, HWND hWnd,
							int OpenLast, bool TurnMoving, bool OneByOne, bool ToAdd,
							HMENU hMenu);
		bool CheckWin(bool Mes);
		~CGame();
};

#endif