#include <windows.h>
#include <string>

#include "resource.h"
#include "objects.h"

#define WM_MOUSELEAVE                   0x02A3

/****************************************************************/
/* Globals                                                      */
/****************************************************************/

HINSTANCE ghInstance;
CGame ThisGame;
int PrevX, PrevY;
bool ActionOn;
bool State;
bool LeftButtonDown;
bool RightButtonDown;
bool MenuClick;
bool PictOn;

/****************************************************************/
/* Pre-Declarations                                             */
/****************************************************************/

LRESULT WINAPI MainWndProc( HWND, UINT, WPARAM, LPARAM );

/****************************************************************/
/* WinMain - Creation of Main Window                            */
/****************************************************************/

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow )
{
	WNDCLASSEX wc;
	MSG msg;
	HWND hWnd;
	BOOL bRet;


	if( !hPrevInstance )
	{
		memset (&wc, 0, sizeof(wc));
		wc.cbSize        = sizeof(WNDCLASSEX);
		wc.lpszClassName = "DrawAppWndClass";
		wc.lpfnWndProc = MainWndProc;
		wc.style = CS_VREDRAW | CS_HREDRAW | CS_DBLCLKS;
		wc.hInstance = hInstance;
		wc.hIcon = LoadIcon( hInstance, MAKEINTRESOURCE ( IDI_MAINICON ) );
		wc.hIconSm = wc.hIcon;
		wc.hCursor = LoadCursor( NULL, IDC_ARROW );
		wc.hbrBackground = (HBRUSH)(COLOR_BACKGROUND+2);
		wc.lpszMenuName = NULL;
		wc.cbClsExtra = 0;
		wc.cbWndExtra = 0;

		RegisterClassEx( &wc );
	}

	ghInstance = hInstance;

	hWnd = CreateWindow
	( 
		"DrawAppWndClass", 
		"Patience",
		WS_OVERLAPPEDWINDOW,
		0,
		0,
		770,
		590,
		NULL,
		NULL,
		hInstance,
		NULL 
	);

	HMENU hMenu = LoadMenu(hInstance, "MainMenu");
	SetMenu(hWnd, hMenu);
	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	State = false;

	EnableMenuItem(hMenu, ID_MENU_UNDO, MF_GRAYED);
	EnableMenuItem(hMenu, ID_MENU_REDO, MF_GRAYED);
	if (!ThisGame.GetSuccess())
		ThisGame.NewGame("New", hWnd, hMenu, PictOn);
	else ThisGame.SetHistoryMenu(hMenu);
	LeftButtonDown = false;
	RightButtonDown = false;
	MenuClick = false;
	PictOn = false;

	while( (bRet = GetMessage( &msg, NULL, 0, 0 )) != 0 )
	{
		if (bRet == -1)
		{
			// handle the error and possibly exit
		}
		else
		{
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
	}
	
	UnregisterClass ( "DrawAppWndClass", hInstance );

	return (int)msg.wParam;
}
/**** ************************************************************/
/* Main Window Procedure                                        */
/****************************************************************/
LRESULT CALLBACK MainWndProc ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	PAINTSTRUCT ps;    
	HDC pDC;
	HMENU hMenu = GetMenu(hWnd);
	switch (msg)
	{
    
		case WM_ERASEBKGND:
			return 1; 

		case WM_PAINT:   
		{  
			pDC = BeginPaint(hWnd, &ps );
			ThisGame.Draw(pDC, 0, 0,
				ps.rcPaint.right, ps.rcPaint.bottom, PictOn);
			EndPaint(hWnd, &ps );
			break;
		}
		case WM_COMMAND:  
		{
			switch (LOWORD(wParam))
			{
				case ID_MENU_NEW:
				{		
					if((!RightButtonDown) && (!ActionOn) 
						&& (ThisGame.TemporaryPileIsAvailable())
						&& (!ThisGame.TemporaryPileIsVisible()))
					{
						PictOn = false;
						ThisGame.NewGame("New", hWnd, hMenu, PictOn);
					}
					LeftButtonDown = false;
					RedrawWindow (hWnd, NULL, NULL, RDW_INVALIDATE );
					break;
				}
			
				case ID_MENU_RESTART:
				{
					if((!RightButtonDown) && (!ActionOn) 
						&& (ThisGame.TemporaryPileIsAvailable())
						&& (!ThisGame.TemporaryPileIsVisible()))
					{
						PictOn = false;
						ThisGame.NewGame("Restart", hWnd, hMenu, PictOn);
					}
					LeftButtonDown = false;
					RedrawWindow (hWnd, NULL, NULL, RDW_INVALIDATE );
					break;
				}
				case ID_MENU_UNDO:
				{
					if((!RightButtonDown) && (!ActionOn)  && (!PictOn)
						&& (ThisGame.TemporaryPileIsAvailable())
						&& (!ThisGame.TemporaryPileIsVisible()))
							ThisGame.MakeOneStep(false, hWnd, hMenu);
					LeftButtonDown = false;
					RedrawWindow (hWnd, NULL, NULL, RDW_INVALIDATE );
					break;
				}
			case ID_MENU_REDO:
				{
					if((!RightButtonDown) && (!ActionOn)  && (!PictOn)
						&& (ThisGame.TemporaryPileIsAvailable())
						&& (!ThisGame.TemporaryPileIsVisible()))
							ThisGame.MakeOneStep(true, hWnd, hMenu);
					LeftButtonDown = false;
					RedrawWindow (hWnd, NULL, NULL, RDW_INVALIDATE );
				}
				break;
			}
			break;
		}
		case WM_LBUTTONDOWN:
		{
			PrevX = LOWORD(lParam);
			PrevY = HIWORD(lParam);
			if((!RightButtonDown) && (!ActionOn) && (!PictOn)
				&& (ThisGame.TemporaryPileIsAvailable())
				&& (!ThisGame.TemporaryPileIsVisible()))
			{
				LeftButtonDown = true;
				ActionOn = ThisGame.GetCardsToMove(PrevX, PrevY, hWnd, hMenu, "Move");
				RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
							}
			else 
				if (!RightButtonDown)ActionOn = false;//
			break;
		}
		case WM_RBUTTONDOWN:
		{
			PrevX = LOWORD(lParam);
			PrevY = HIWORD(lParam);
			if((!LeftButtonDown) && (!ActionOn) && (!PictOn)
				&& (ThisGame.TemporaryPileIsAvailable())
				&& (!ThisGame.TemporaryPileIsVisible()))
			{
				RightButtonDown = true;
				bool res = true;
				ActionOn = true; 
				ThisGame.GetCardsToMove(PrevX, PrevY, hWnd, hMenu, "FindStep");
				ActionOn = false;
				RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
				while (res)
				{
					res = ThisGame.AutoStep(hWnd, hMenu, PictOn);
					RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
				}
			}
			else 
				if (!LeftButtonDown) ActionOn = false;
			break;
		}
		case WM_MOUSEMOVE:
		{
			bool lButtonDown=wParam & MK_LBUTTON;
			if (lButtonDown) 
			{
				int MouseX=(short)LOWORD(lParam);
				int MouseY=(short)HIWORD(lParam);
				if(LeftButtonDown && ActionOn && (!PictOn)
					&& (ThisGame.TemporaryPileIsAvailable())
					&& (ThisGame.TemporaryPileIsVisible())) 
				{	
					ThisGame.ChangeCoordsOfTemporaryPile(MouseX-PrevX,MouseY-PrevY);			
					RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
				}
				PrevX=MouseX;
				PrevY=MouseY;
			}
			else
			{

				if(LeftButtonDown && ActionOn && (!PictOn)
					&& (ThisGame.TemporaryPileIsAvailable())
					&& (ThisGame.TemporaryPileIsVisible()))
				{
					ThisGame.ReturnCardsOnAlert(hWnd);	
					RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
				}
			}
			break;
		}

		case WM_LBUTTONUP:
		{
			PrevX = LOWORD(lParam);
			PrevY = HIWORD(lParam);

			if(LeftButtonDown && ActionOn && (!PictOn)
				&& (ThisGame.TemporaryPileIsAvailable())
				&& (ThisGame.TemporaryPileIsVisible())) 
			{
				bool res;
				ThisGame.EndOfMovement(PrevX, PrevY, res, hWnd, hMenu);
				RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
				while (res)
				{
					res = ThisGame.AutoStep(hWnd, hMenu, PictOn);
					RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
				}
				ActionOn = false;
			}
			ActionOn = false; 
			LeftButtonDown = false;
			break;
		}

		case WM_RBUTTONUP:
		{
			RightButtonDown = false;
			break;
		}
		
		case WM_CAPTURECHANGED:
		{
			if((ThisGame.TemporaryPileIsAvailable())
				&& (ThisGame.TemporaryPileIsVisible())) 
			{	
				ThisGame.ReturnCardsOnAlert(hWnd);	
				RedrawWindow ( hWnd, NULL, NULL, RDW_INVALIDATE );
			}
			break;
		}

		case WM_DESTROY:  
			{
				bool SaveRes;
				SaveRes = ThisGame.Save();
				PostQuitMessage( 0 );
			}

		default:
			return( DefWindowProc( hWnd, msg, wParam, lParam ));
	}
	return 0;
}



